/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.samples.ui.views;

import com.aptana.samples.model.SampleCategory;
import com.aptana.samples.model.SamplesReference;
import com.aptana.samples.ui.SamplesUIPlugin;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class SamplesViewLabelProvider
extends ColumnLabelProvider {
    private static final Image IMAGE_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final String ICON_REMOTE = "icons/samples_remote.gif";
    private static final String ICON_SIZE = "16";
    private ImageRegistry imageRegistry = new ImageRegistry();

    public void dispose() {
        this.imageRegistry.dispose();
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof SampleCategory) {
            SampleCategory category = (SampleCategory)element;
            URL iconFile = category.getIconFile();
            if (iconFile != null) {
                Image image = this.imageRegistry.get(category.getId());
                if (image == null) {
                    ImageDescriptor desc = ImageDescriptor.createFromURL((URL)iconFile);
                    this.imageRegistry.put(category.getId(), desc);
                }
                return this.imageRegistry.get(category.getId());
            }
            return IMAGE_FOLDER;
        }
        if (element instanceof SamplesReference) {
            SamplesReference sample = (SamplesReference)element;
            URL url = sample.getIconUrl(ICON_SIZE);
            if (url == null) {
                url = sample.getIconUrl();
            }
            if (url != null) {
                String key = url.toString();
                Image image = this.imageRegistry.get(key);
                if (image == null) {
                    this.imageRegistry.put(key, ImageDescriptor.createFromURL((URL)url));
                    image = this.imageRegistry.get(key);
                }
                return image;
            }
            return SamplesUIPlugin.getImage(ICON_REMOTE);
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof SampleCategory) {
            return ((SampleCategory)element).getName();
        }
        if (element instanceof SamplesReference) {
            SamplesReference samplesRef = (SamplesReference)element;
            String name = samplesRef.getName();
            return name == null ? samplesRef.getLocation() : name;
        }
        return super.getText(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof SampleCategory) {
            return ((SampleCategory)element).getName();
        }
        if (element instanceof SamplesReference) {
            SamplesReference samplesRef = (SamplesReference)element;
            String toolTipText = samplesRef.getDescription();
            if (toolTipText == null) {
                toolTipText = samplesRef.getName();
            }
            if (toolTipText == null) {
                toolTipText = samplesRef.getLocation();
            }
            return toolTipText;
        }
        return super.getText(element);
    }
}

